/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapgen.generators;

import java.util.Random;
import technology.rocketjump.undermount.mapgen.generators.SimplexNoiseOctave;

public class SimplexNoise {
    SimplexNoiseOctave[] octaves;
    double[] frequencys;
    double[] amplitudes;
    int largestFeature;
    double persistence;

    public SimplexNoise(int largestFeature, double persistence, Random random) {
        this.largestFeature = largestFeature;
        this.persistence = persistence;
        int numberOfOctaves = (int)Math.ceil(Math.log10(largestFeature) / Math.log10(2.0));
        this.octaves = new SimplexNoiseOctave[numberOfOctaves];
        this.frequencys = new double[numberOfOctaves];
        this.amplitudes = new double[numberOfOctaves];
        for (int i = 0; i < numberOfOctaves; ++i) {
            this.octaves[i] = new SimplexNoiseOctave(random);
            this.frequencys[i] = Math.pow(2.0, i);
            this.amplitudes[i] = Math.pow(persistence, this.octaves.length - i);
        }
    }

    public double getNoise(int x, int y) {
        double result = 0.0;
        for (int i = 0; i < this.octaves.length; ++i) {
            result += this.octaves[i].noise((double)x / this.frequencys[i], (double)y / this.frequencys[i]) * this.amplitudes[i];
        }
        return result;
    }

    public double getNoise(int x, int y, int z) {
        double result = 0.0;
        for (int i = 0; i < this.octaves.length; ++i) {
            double frequency = Math.pow(2.0, i);
            double amplitude = Math.pow(this.persistence, this.octaves.length - i);
            result += this.octaves[i].noise((double)x / frequency, (double)y / frequency, (double)z / frequency) * amplitude;
        }
        return result;
    }
}

